package ru.foodtechlab.lib.auth.integration.restapi.feign.authorization.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import ru.foodtechlab.aeh.core.Error;
import ru.foodtechlab.aeh.core.ErrorApiResponse;
import ru.foodtechlab.lib.auth.integration.core.AccessTokenService;
import ru.foodtechlab.lib.auth.integration.core.authorizationSession.exception.AuthorizationSessionServiceException;
import ru.foodtechlab.lib.auth.integration.core.credential.exception.*;
import ru.foodtechlab.lib.auth.integration.restapi.feign.commons.AuthorizationErrorDecoder;

@Slf4j
public class FeignAuthorizationSessionServiceErrorDecoder extends AuthorizationErrorDecoder {

    public FeignAuthorizationSessionServiceErrorDecoder(ObjectMapper mapper, AccessTokenService accessTokenService) {
        super(mapper, accessTokenService);
    }

    @SneakyThrows
    @Override
    public Exception decode(ErrorApiResponse<Error> errorApiResponse) {
        return new AuthorizationSessionServiceException(errorApiResponse);
    }
}
