package ru.foodtechlab.lib.auth.integration.proxy.api.accessToken.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.AccessTokenServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.token.exception.AccessTokenNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.resources.AccessTokenResource;
import ru.foodtechlab.lib.auth.service.facade.accessToken.routers.AccessTokenRoutes;

@RequiredArgsConstructor
public class AccessTokenProxyApiController implements AccessTokenResource {
    private final AccessTokenServiceFacade accessTokenServiceFacade;

    @Override
    @PostMapping(value = AccessTokenRoutes.JWT_DECODE)
    public SuccessApiResponse<AccessTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request) {
        return SuccessApiResponse.of(accessTokenServiceFacade.decode(request));
    }

    @Override
    @PostMapping(value = AccessTokenRoutes.JWT_ENCODE)
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable String id) {
        return SuccessApiResponse.of(accessTokenServiceFacade.encode(id));
    }

    @Override
    @GetMapping(value = AccessTokenRoutes.BY_ID)
    public SuccessApiResponse<AccessTokenResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of(accessTokenServiceFacade.findById(id)
                .orElseThrow(AccessTokenNotFoundException::new));
    }

    @Override
    @GetMapping(value = AccessTokenRoutes.ROOT)
    public SuccessApiResponse<SearchResult<AccessTokenResponse>> find(@ModelAttribute AccessTokenFiltersRequest request) {
        return SuccessApiResponse.of(accessTokenServiceFacade.find(request));
    }

    @Override
    @PostMapping(value = AccessTokenRoutes.EXPIRED_BY_STATUS)
    public OkApiResponse expireByStatus(@PathVariable String id) {
        accessTokenServiceFacade.expireByStatus(id);
        return OkApiResponse.of();
    }


    @Override
    @PostMapping(AccessTokenRoutes.DEACTIVATE_BY_CRED)
    public OkApiResponse deactivateByCredential(@RequestBody DeactivateByCredentialRequest request) {
        accessTokenServiceFacade.deactivateByCredentialId(request.getCredentialId());
        return new OkApiResponse();
    }

    @Override
    @PostMapping(value = AccessTokenRoutes.EXPIRED_BY_TIME)
    public OkApiResponse expireByTime(@PathVariable String id) {
        accessTokenServiceFacade.expireByTime(id);
        return new OkApiResponse();
    }
}
