package ru.foodtechlab.lib.auth.integration.proxy.api.preference.v1.controllers;

import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.integration.core.preference.ServicePreferenceFacade;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.requests.UpdateServicePreferenceRequest;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.responses.ServicePreferenceResponse;
import ru.foodtechlab.lib.auth.service.facade.preference.resources.ServicePreferencesResource;
import ru.foodtechlab.lib.auth.service.facade.preference.routers.GetPreferenceRoutes;

@RequiredArgsConstructor
public class ServicePreferencesProxyApiResource implements ServicePreferencesResource {
    private final ServicePreferenceFacade servicePreferenceFacade;

    @Override
    @GetMapping(value = GetPreferenceRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<ServicePreferenceResponse> get() {
        return SuccessApiResponse.of(servicePreferenceFacade.get());
    }

    @Override
    @PutMapping(value = GetPreferenceRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<ServicePreferenceResponse> update(@RequestBody UpdateServicePreferenceRequest request) {
        return SuccessApiResponse.of(servicePreferenceFacade.update(request));
    }
}
