/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.proxy.api.role.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import ru.foodtechlab.lib.auth.integration.core.role.RoleServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.role.exception.RoleNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.CreateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.SearchRoleWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.UpdateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.responses.RoleResponse;
import ru.foodtechlab.lib.auth.service.facade.role.resources.RoleResource;

public class RoleProxyApiController
implements RoleResource {
    private final RoleServiceFacade roleServiceFacade;

    @PostMapping(value={"/api/v1/roles"})
    public SuccessApiResponse<RoleResponse> create(@RequestBody CreateRoleRequest createRoleRequest) {
        return SuccessApiResponse.of((Object)this.roleServiceFacade.create(createRoleRequest));
    }

    @GetMapping(value={"/api/v1/roles/{id}"})
    public SuccessApiResponse<RoleResponse> find(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((RoleResponse)this.roleServiceFacade.findById(id).orElseThrow(RoleNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/roles"})
    public SuccessApiResponse<SearchResult<RoleResponse>> find(@ModelAttribute SearchRoleWithFiltersRequest request) {
        return SuccessApiResponse.of((Object)this.roleServiceFacade.find(request));
    }

    @PutMapping(value={"/api/v1/roles/{id}"})
    public SuccessApiResponse<RoleResponse> update(@PathVariable String id, @RequestBody UpdateRoleRequest request) {
        return SuccessApiResponse.of((Object)this.roleServiceFacade.update(id, request));
    }

    @GetMapping(value={"/api/v1/roles/find-by-code"})
    public SuccessApiResponse<RoleResponse> findByCode(@RequestParam String code) {
        return SuccessApiResponse.of((Object)((RoleResponse)this.roleServiceFacade.findByCode(code).orElseThrow(RoleNotFoundException::new)));
    }

    @DeleteMapping(value={"/api/v1/roles/{id}"}, produces={"application/json"})
    public OkApiResponse delete(@PathVariable String id) {
        this.roleServiceFacade.delete(id);
        return OkApiResponse.of();
    }

    public RoleProxyApiController(RoleServiceFacade roleServiceFacade) {
        this.roleServiceFacade = roleServiceFacade;
    }
}

