/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.proxy.api.accessToken.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.integration.core.token.accessToken.AccessTokenServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.token.exception.AccessTokenNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.AccessTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DeactivateByCredentialRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.accessToken.resources.AccessTokenResource;

public class AccessTokenProxyApiController
implements AccessTokenResource {
    private final AccessTokenServiceFacade accessTokenServiceFacade;

    @PostMapping(value={"/api/v1/access-tokens/jwt/decode"})
    public SuccessApiResponse<AccessTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request) {
        return SuccessApiResponse.of((Object)this.accessTokenServiceFacade.decode(request));
    }

    @PostMapping(value={"/api/v1/access-tokens/{id}/jwt/encode"})
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable String id) {
        return SuccessApiResponse.of((Object)this.accessTokenServiceFacade.encode(id));
    }

    @GetMapping(value={"/api/v1/access-tokens/{id}"})
    public SuccessApiResponse<AccessTokenResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((AccessTokenResponse)this.accessTokenServiceFacade.findById(id).orElseThrow(AccessTokenNotFoundException::new)));
    }

    @GetMapping(value={"/api/v1/access-tokens"})
    public SuccessApiResponse<SearchResult<AccessTokenResponse>> find(@ModelAttribute AccessTokenFiltersRequest request) {
        return SuccessApiResponse.of((Object)this.accessTokenServiceFacade.find(request));
    }

    @PostMapping(value={"/api/v1/access-tokens/{id}/expired-by-status"})
    public OkApiResponse expireByStatus(@PathVariable String id) {
        this.accessTokenServiceFacade.expireByStatus(id);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/access-tokens/deactivate-by-credential"})
    public OkApiResponse deactivateByCredential(@RequestBody DeactivateByCredentialRequest request) {
        this.accessTokenServiceFacade.deactivateByCredentialId(request.getCredentialId());
        return new OkApiResponse();
    }

    @PostMapping(value={"/api/v1/access-tokens/{id}/expired-by-time"})
    public OkApiResponse expireByTime(@PathVariable String id) {
        this.accessTokenServiceFacade.expireByTime(id);
        return new OkApiResponse();
    }

    public AccessTokenProxyApiController(AccessTokenServiceFacade accessTokenServiceFacade) {
        this.accessTokenServiceFacade = accessTokenServiceFacade;
    }
}

