package ru.foodtechlab.lib.auth.integration.proxy.api.security.v1.controllers;

import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.CheckAccessServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.security.resources.SecurityResource;
import ru.foodtechlab.lib.auth.service.facade.security.routers.SecurityRoutes;

@RequiredArgsConstructor
public class SecurityProxyApiController implements SecurityResource {

    private final CheckAccessServiceFacade checkAccessServiceFacade;

    @Override
    @PostMapping(value = SecurityRoutes.CHECK_TOKEN, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<CredentialDetails> checkAccess(CheckAccessByTokenRequest request) {
        return SuccessApiResponse.of(checkAccessServiceFacade.checkAccess(request));
    }

    @Override
    @PostMapping(value = SecurityRoutes.CHECK_ACCESS, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse checkToken(String token) {
        checkAccessServiceFacade.tokenIsValid(token);
        return OkApiResponse.of();
    }

    @Override
    @GetMapping(value = SecurityRoutes.CURRENT_USER, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<CredentialDetails> getCurrentUserByToken(String token) {
        throw new RuntimeException("Dont have any idea, how to fix");
    }
}
