package ru.foodtechlab.lib.auth.integration.proxy.api.confirmationCode.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import ru.foodtechlab.lib.auth.integration.core.confirmationCode.ConfirmationCodeServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.confirmationCode.exception.ConfirmationCodeNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.requests.SearchConfirmationCodeWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.responses.ConfirmationCodeResponse;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.resources.ConfirmationCodeResource;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.routers.ConfirmationRoutes;

@RequiredArgsConstructor
public class ConfirmationCodeProxyApiController implements ConfirmationCodeResource {

    private final ConfirmationCodeServiceFacade confirmationCodeServiceFacade;

    @Override
    @GetMapping(value = ConfirmationRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<ConfirmationCodeResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of(confirmationCodeServiceFacade.findById(id)
                .orElseThrow(() -> new ConfirmationCodeNotFoundException("Confirmation code not found by ID: " + id)));
    }

    @Override
    @GetMapping(value = ConfirmationRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<SearchResult<ConfirmationCodeResponse>> find(@ModelAttribute SearchConfirmationCodeWithFiltersRequest request) {
        return SuccessApiResponse.of(confirmationCodeServiceFacade.find(request));
    }

}
