/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.proxy.api.authorization.v1.controllers;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthorizationServiceFacade;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.BasicEmailAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.BasicUsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.EmailAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.LogoutRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.PhoneNumberAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.RefreshTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpByPhoneNumberRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpConfirmationByEmailRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.SignUpConfirmationByPhoneNumberRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.requests.UsernameAuthorizationRequest;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;
import ru.foodtechlab.lib.auth.service.facade.authorization.resources.AuthorizationResource;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

public class AuthorizationProxyApiController
implements AuthorizationResource {
    private final AuthorizationServiceFacade authorizationServiceFacade;

    @GetMapping(value={"/not-secure/api/v1/auth/logout"})
    public OkApiResponse logout(@RequestParam String accessToken) {
        LogoutRequest request = new LogoutRequest(accessToken);
        this.authorizationServiceFacade.logout(request);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/not-secure/api/v1/auth/refresh"})
    public SuccessApiResponse<BasicAuthorizationResponse> refreshToken(@RequestBody RefreshTokenRequest refreshTokenRequest) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.refreshToken(refreshTokenRequest));
    }

    @Deprecated(forRemoval=true)
    @PostMapping(value={"/not-secure/api/v1/auth/login/email"})
    public SuccessApiResponse<BasicAuthorizationResponse> emailAuthorization(@RequestBody BasicEmailAuthorizationRequest request) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        EmailAuthorizationRequest emailAuthorizationRequest = EmailAuthorizationRequest.of((String)request.getEmail(), (String)request.getPassword());
        emailAuthorizationRequest.setIp(httpServletRequest.getRemoteAddr());
        emailAuthorizationRequest.setDeviceId("proxy-support-legacy-device-id");
        emailAuthorizationRequest.setApplicationDetails(AuthorizationSessionResponse.ApplicationDetails.builder().name("proxy-support-legacy-device").platform("consumer").versionName("legacy").build());
        emailAuthorizationRequest.setIsRegistrationAllowed(Boolean.valueOf(false));
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.emailAuthorization(emailAuthorizationRequest));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/login/password"})
    public SuccessApiResponse<BasicAuthorizationResponse> usernameAuthorization(@RequestBody BasicUsernameAuthorizationRequest request) {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UsernameAuthorizationRequest usernameAuthorizationRequest = UsernameAuthorizationRequest.of((String)request.getUsername(), (String)request.getPassword());
        usernameAuthorizationRequest.setIp(httpServletRequest.getRemoteAddr());
        usernameAuthorizationRequest.setDeviceId("proxy-support-legacy-device-id");
        usernameAuthorizationRequest.setApplicationDetails(AuthorizationSessionResponse.ApplicationDetails.builder().name("proxy-support-legacy-device").platform("consumer").versionName("legacy").build());
        usernameAuthorizationRequest.setIsRegistrationAllowed(Boolean.valueOf(false));
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.usernameAuthorization(usernameAuthorizationRequest));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/one-step/with-password/email"})
    public SuccessApiResponse<BasicAuthorizationResponse> emailAuthorization(@RequestBody EmailAuthorizationRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.emailAuthorization(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/one-step/with-password/phone"})
    public SuccessApiResponse<BasicAuthorizationResponse> phoneAuthorization(@RequestBody PhoneNumberAuthorizationRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.phoneNumberAuthorization(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/one-step/with-password/username"})
    public SuccessApiResponse<BasicAuthorizationResponse> usernameAuthorization(@RequestBody UsernameAuthorizationRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.usernameAuthorization(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/logout"})
    public OkApiResponse logout(@RequestBody LogoutRequest request) {
        this.authorizationServiceFacade.logout(request);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/two-steps/with-confirmation/email/confirm"})
    public SuccessApiResponse<BasicAuthorizationResponse> signUpConfirmationByEmail(@RequestBody SignUpConfirmationByEmailRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.signUpConfirmationByEmail(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/two-steps/with-confirmation/email/init"})
    public SuccessApiResponse<ConfirmationCodeTimerResponse> signUpByEmail(@RequestBody SignUpByEmailRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.singUpByEmail(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/two-steps/with-confirmation/phone/confirm"})
    public SuccessApiResponse<BasicAuthorizationResponse> signUpConfirmationByPhoneNumber(@RequestBody SignUpConfirmationByPhoneNumberRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.signUpConfirmationByPhoneNumber(request));
    }

    @PostMapping(value={"/not-secure/api/v1/auth/single-factor/two-steps/with-confirmation/phone/init"})
    public SuccessApiResponse<ConfirmationCodeTimerResponse> signUpByPhoneNumber(@RequestBody SignUpByPhoneNumberRequest request) {
        return SuccessApiResponse.of((Object)this.authorizationServiceFacade.singUpByPhoneNumber(request));
    }

    public AuthorizationProxyApiController(AuthorizationServiceFacade authorizationServiceFacade) {
        this.authorizationServiceFacade = authorizationServiceFacade;
    }
}

