package ru.foodtechlab.lib.auth.integration.proxy.api.refreshToken.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.RefreshTokenServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.exception.RefreshTokenNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.resources.RefreshTokenResource;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.routers.RefreshTokenRoutes;

@RequiredArgsConstructor
public class RefreshTokenProxyApiController implements RefreshTokenResource {
    private final RefreshTokenServiceFacade refreshTokenServiceFacade;

    @Override
    @PostMapping(value = RefreshTokenRoutes.JWT_DECODE)
    public SuccessApiResponse<RefreshTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request) {
        return SuccessApiResponse.of(refreshTokenServiceFacade.decode(request));
    }

    @Override
    @PostMapping(value = RefreshTokenRoutes.JWT_ENCODE)
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable String id) {
        return SuccessApiResponse.of(refreshTokenServiceFacade.encode(id));
    }

    @Override
    @GetMapping(value = RefreshTokenRoutes.BY_ID)
    public SuccessApiResponse<RefreshTokenResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of(refreshTokenServiceFacade.findById(id)
                .orElseThrow(() -> new RefreshTokenNotFoundException("Refresh token not found")));
    }

    @Override
    @GetMapping(value = RefreshTokenRoutes.ROOT)
    public SuccessApiResponse<SearchResult<RefreshTokenResponse>> find(@ModelAttribute RefreshTokenFiltersRequest request) {
        return SuccessApiResponse.of(refreshTokenServiceFacade.find(request));
    }

    @Override
    @PostMapping(value = RefreshTokenRoutes.EXPIRED_BY_STATUS)
    public OkApiResponse expireByStatus(@PathVariable String id) {
        refreshTokenServiceFacade.expireByStatus(id);
        return OkApiResponse.of();
    }

    @Override
    @PostMapping(value = RefreshTokenRoutes.EXPIRED_BY_TIME)
    public OkApiResponse expireByTime(@PathVariable String id) {
        refreshTokenServiceFacade.expireByTime(id);
        return OkApiResponse.of();
    }
}
