/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.proxy.api.refreshToken.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.RefreshTokenServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.token.refreshToken.exception.RefreshTokenNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.requests.DecodeTokenRequest;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.EncodedTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.requests.RefreshTokenFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.resources.RefreshTokenResource;

public class RefreshTokenProxyApiController
implements RefreshTokenResource {
    private final RefreshTokenServiceFacade refreshTokenServiceFacade;

    @PostMapping(value={"/api/v1/refresh-tokens/jwt/decode"})
    public SuccessApiResponse<RefreshTokenResponse> decodeJwt(@RequestBody DecodeTokenRequest request) {
        return SuccessApiResponse.of((Object)this.refreshTokenServiceFacade.decode(request));
    }

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/jwt/encode"})
    public SuccessApiResponse<EncodedTokenResponse> encodeToJwt(@PathVariable String id) {
        return SuccessApiResponse.of((Object)this.refreshTokenServiceFacade.encode(id));
    }

    @GetMapping(value={"/api/v1/refresh-tokens/{id}"})
    public SuccessApiResponse<RefreshTokenResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of((Object)((RefreshTokenResponse)this.refreshTokenServiceFacade.findById(id).orElseThrow(() -> new RefreshTokenNotFoundException((Object)"Refresh token not found"))));
    }

    @GetMapping(value={"/api/v1/refresh-tokens"})
    public SuccessApiResponse<SearchResult<RefreshTokenResponse>> find(@ModelAttribute RefreshTokenFiltersRequest request) {
        return SuccessApiResponse.of((Object)this.refreshTokenServiceFacade.find(request));
    }

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/expired-by-status"})
    public OkApiResponse expireByStatus(@PathVariable String id) {
        this.refreshTokenServiceFacade.expireByStatus(id);
        return OkApiResponse.of();
    }

    @PostMapping(value={"/api/v1/refresh-tokens/{id}/expired-by-time"})
    public OkApiResponse expireByTime(@PathVariable String id) {
        this.refreshTokenServiceFacade.expireByTime(id);
        return OkApiResponse.of();
    }

    public RefreshTokenProxyApiController(RefreshTokenServiceFacade refreshTokenServiceFacade) {
        this.refreshTokenServiceFacade = refreshTokenServiceFacade;
    }
}

