package ru.foodtechlab.lib.auth.integration.proxy.api.roleAccess.v1.controllers;

import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SearchApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.RoleAccessServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.exception.RoleAccessNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CreateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.FindRoleAccessWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.UpdateRoleAccessRequest;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.resources.RoleAccessResource;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.routers.RoleAccessRoutes;

@RequiredArgsConstructor
public class RoleAccessProxyApiController implements RoleAccessResource {
    private final RoleAccessServiceFacade roleAccessServiceFacade;

    @Override
    @PostMapping(value = RoleAccessRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<RoleAccessResponse> create(@RequestBody CreateRoleAccessRequest request) {
        return SuccessApiResponse.of(roleAccessServiceFacade.create(request));
    }

    @Override
    @DeleteMapping(value = RoleAccessRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse delete(@PathVariable String id) {
        roleAccessServiceFacade.delete(id);
        return OkApiResponse.of();
    }

    @Override
    @GetMapping(value = RoleAccessRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<RoleAccessResponse> findById(@PathVariable String id) {
        return SuccessApiResponse.of(roleAccessServiceFacade.findById(id)
                .orElseThrow(RoleAccessNotFoundException::new));
    }

    @Override
    @GetMapping(value = RoleAccessRoutes.ROOT, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<SearchApiResponse<RoleAccessResponse>> find(@ModelAttribute FindRoleAccessWithFiltersRequest request) {
        var result = roleAccessServiceFacade.find(request);
        return SuccessApiResponse.of(SearchApiResponse.withItemsAndCount(
                result.getItems(),
                result.getCount()
        ));
    }

    @Override
    @PutMapping(value = RoleAccessRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public SuccessApiResponse<RoleAccessResponse> update(@PathVariable String id,@RequestBody UpdateRoleAccessRequest request) {
        return SuccessApiResponse.of(roleAccessServiceFacade.update(id, request));
    }
}
