package ru.foodtechlab.lib.auth.integration.proxy.api.role.v1.controllers;

import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.rest.api.commons.response.OkApiResponse;
import com.rcore.rest.api.commons.response.SuccessApiResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import ru.foodtechlab.lib.auth.integration.core.role.RoleServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.role.exception.RoleNotFoundException;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.CreateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.SearchRoleWithFiltersRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.requests.UpdateRoleRequest;
import ru.foodtechlab.lib.auth.service.facade.role.dto.responses.RoleResponse;
import ru.foodtechlab.lib.auth.service.facade.role.resources.RoleResource;
import ru.foodtechlab.lib.auth.service.facade.role.routers.RoleApiRoutes;

@RequiredArgsConstructor
public class RoleProxyApiController implements RoleResource {
    private final RoleServiceFacade roleServiceFacade;

    @Override
    @PostMapping(value = RoleApiRoutes.ROOT)
    public SuccessApiResponse<RoleResponse> create(@RequestBody CreateRoleRequest createRoleRequest) {
        return SuccessApiResponse.of(roleServiceFacade.create(createRoleRequest));
    }

    @Override
    @GetMapping(value = RoleApiRoutes.BY_ID)
    public SuccessApiResponse<RoleResponse> find(@PathVariable String id) {
        return SuccessApiResponse.of(roleServiceFacade.findById(id)
                .orElseThrow(RoleNotFoundException::new));
    }

    @Override
    @GetMapping(value = RoleApiRoutes.ROOT)
    public SuccessApiResponse<SearchResult<RoleResponse>> find(@ModelAttribute SearchRoleWithFiltersRequest request) {
        return SuccessApiResponse.of(roleServiceFacade.find(request));
    }

    @Override
    @PutMapping(value = RoleApiRoutes.BY_ID)
    public SuccessApiResponse<RoleResponse> update(@PathVariable String id, @RequestBody UpdateRoleRequest request) {
        return SuccessApiResponse.of(roleServiceFacade.update(id, request));
    }

    @Override
    @GetMapping(value = RoleApiRoutes.FIND_BY_CODE)
    public SuccessApiResponse<RoleResponse> findByCode(@RequestParam String code) {
        return SuccessApiResponse.of(roleServiceFacade.findByCode(code)
                .orElseThrow(RoleNotFoundException::new));
    }

    @Override
    @DeleteMapping(value = RoleApiRoutes.BY_ID, produces = MediaType.APPLICATION_JSON_VALUE)
    public OkApiResponse delete(@PathVariable String id) {
        roleServiceFacade.delete(id);
        return OkApiResponse.of();
    }
}
