/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.integration.autoconfigure;

import com.rcore.domain.security.port.AccessChecker;
import com.rcore.domain.security.port.CredentialIdentityService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import ru.foodtechlab.lib.auth.integration.core.FoodtechlabGroupProperties;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.AuthCredentialServiceFacade;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.impl.AccessCheckerViaAuthService;
import ru.foodtechlab.lib.auth.integration.core.authorizartion.impl.CredentialIdentityServiceViaAuthService;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.CheckAccessServiceFacade;

@EnableFeignClients(basePackages={"ru.foodtechlab.lib"})
@EnableGlobalMethodSecurity(securedEnabled=true)
@Configuration
@AutoConfigureAfter(value={FeignAutoConfiguration.class})
@EnableConfigurationProperties(value={FoodtechlabGroupProperties.class})
public class AuthIntegrationAuthConfiguration {
    @Bean
    public CredentialIdentityService credentialIdentityService(AuthCredentialServiceFacade authCredentialServiceFacade) {
        return new CredentialIdentityServiceViaAuthService(authCredentialServiceFacade);
    }

    @Bean
    public AccessChecker accessChecker(CheckAccessServiceFacade checkAccessServiceFacade) {
        return new AccessCheckerViaAuthService(checkAccessServiceFacade);
    }
}

