/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.domain.commons.port.dto.SearchFilters;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import java.util.HashSet;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.RefreshTokenFilters;

public class FindRefreshTokensQuery
extends AbstractExampleQuery {
    private final RefreshTokenFilters filters;

    public FindRefreshTokensQuery(RefreshTokenFilters filters) {
        super((SearchFilters)filters);
        this.filters = filters;
    }

    public Criteria getCriteria() {
        HashSet<Criteria> criteriaSet = new HashSet<Criteria>(3);
        IsDeletedCriteria.filterCriteria((Boolean)this.filters.getDeleted()).ifPresent(criteriaSet::add);
        if (this.filters.getCredentialId() != null) {
            criteriaSet.add(Criteria.where((String)"credential.$id").is((Object)new ObjectId(this.filters.getCredentialId())));
        }
        if (this.filters.getStatus() != null) {
            criteriaSet.add(Criteria.where((String)"status").is((Object)this.filters.getStatus()));
        }
        if (criteriaSet.isEmpty()) {
            return new Criteria();
        }
        return new Criteria().andOperator((Criteria[])criteriaSet.toArray(Criteria[]::new));
    }

    public Query getQuery() {
        return Query.query((CriteriaDefinition)this.getCriteria());
    }
}

