/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractModifyQuery;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;

public class ExpireAccessTokenByRefreshTokenQuery
extends AbstractModifyQuery {
    private final String refreshTokenId;

    public Update getUpdate() {
        return Update.update((String)"status", (Object)RefreshTokenEntity.Status.EXPIRED);
    }

    public FindAndModifyOptions getModifyOptions() {
        return FindAndModifyOptions.options().returnNew(true);
    }

    public Criteria getCriteria() {
        return new Criteria().andOperator(new Criteria[]{IsDeletedCriteria.getNotDeletedCriteria(), Criteria.where((String)"createByRefreshToken.$id").is((Object)new ObjectId(this.refreshTokenId))});
    }

    private ExpireAccessTokenByRefreshTokenQuery(String refreshTokenId) {
        this.refreshTokenId = refreshTokenId;
    }

    public static ExpireAccessTokenByRefreshTokenQuery of(String refreshTokenId) {
        return new ExpireAccessTokenByRefreshTokenQuery(refreshTokenId);
    }
}

