/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.lib.auth.service.domain.token.entity.AccessTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.AccessTokenRepository;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.AccessTokenFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.AccessTokenDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.AccessTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.DeactivateAllAccessTokenByRefreshTokenIdQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.DeactivateAllTokensByCredentialQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.ExpireAccessTokenByRefreshTokenQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.ExpireAccessTokenQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindAccessTokensByRefreshTokenQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindAccessTokensQuery;

@Repository
public class MongoAccessTokenRepository
extends AbstractMongoSafeDeleteRepository<String, AccessTokenEntity, AccessTokenDoc, AccessTokenFilters>
implements AccessTokenRepository {
    public MongoAccessTokenRepository(AccessTokenDocMapper mapper, MongoTemplate mongoTemplate) {
        super(AccessTokenDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public void expireAccessToken(String accessTokenId) {
        ExpireAccessTokenQuery expireAccessTokenQuery = ExpireAccessTokenQuery.of(accessTokenId);
        this.mongoTemplate.updateFirst(expireAccessTokenQuery.getQuery(), (UpdateDefinition)expireAccessTokenQuery.getUpdate(), AccessTokenDoc.class);
    }

    public void expireAllAccessTokenByRefreshTokenId(String refreshTokenId) {
        ExpireAccessTokenByRefreshTokenQuery expireAccessTokenByRefreshTokenQuery = ExpireAccessTokenByRefreshTokenQuery.of(refreshTokenId);
        this.mongoTemplate.updateFirst(expireAccessTokenByRefreshTokenQuery.getQuery(), (UpdateDefinition)expireAccessTokenByRefreshTokenQuery.getUpdate(), AccessTokenDoc.class);
    }

    public void deactivateAllAccessTokenByRefreshTokenId(String refreshTokenId) {
        DeactivateAllAccessTokenByRefreshTokenIdQuery deactivateAllAccessTokenByRefreshTokenIdQuery = DeactivateAllAccessTokenByRefreshTokenIdQuery.of(refreshTokenId);
        this.mongoTemplate.updateFirst(deactivateAllAccessTokenByRefreshTokenIdQuery.getQuery(), (UpdateDefinition)deactivateAllAccessTokenByRefreshTokenIdQuery.getUpdate(), AccessTokenDoc.class);
    }

    public void deactivateByCredentialId(String credentialId) {
        DeactivateAllTokensByCredentialQuery query = DeactivateAllTokensByCredentialQuery.of(credentialId);
        this.mongoTemplate.update(this.documentClass).matching(query.getQuery()).apply((UpdateDefinition)query.getUpdate()).all();
    }

    protected AbstractExampleQuery getSearchQuery(AccessTokenFilters filters) {
        return new FindAccessTokensQuery(filters);
    }

    public List<AccessTokenEntity> findByRefreshTokenId(String refreshTokenId) {
        Query query = FindAccessTokensByRefreshTokenQuery.of(refreshTokenId).getQuery();
        return this.mongoTemplate.find(query, AccessTokenDoc.class).stream().map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0)).collect(Collectors.toList());
    }
}

