/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model;

import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import java.time.Instant;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;

@Document
@CompoundIndexes(value={@CompoundIndex(name="credentialId_status_isDeleted", def="{'credential.$id': 1, 'status': 1, 'isDeleted': 1}"), @CompoundIndex(name="_id_isDeleted", def="{'_id': 1, 'isDeleted': 1}"), @CompoundIndex(name="userId_status_expireAt_isDeleted", def="{'userId': 1, 'status': 1, 'expireAt': 1, 'isDeleted': 1}"), @CompoundIndex(name="isDeleted_credentialId_status", def="{'isDeleted': 1, 'credential.$id': 1, 'status': 1}")})
public class RefreshTokenDoc
extends BaseDeleteDocument {
    @DBRef
    private CredentialDoc credential;
    private Long ttl;
    private Instant expireAt;
    private RefreshTokenEntity.Status status;
    @DBRef
    private RefreshTokenDoc createFromToken;
    private RefreshTokenEntity.CreateFrom createFromType;
    private String salt;
    private String authSessionId;

    @Field(value="isDeleted")
    public boolean isDeleted() {
        return super.isDeleted();
    }

    protected RefreshTokenDoc(RefreshTokenDocBuilder<?, ?> b) {
        super(b);
        this.credential = b.credential;
        this.ttl = b.ttl;
        this.expireAt = b.expireAt;
        this.status = b.status;
        this.createFromToken = b.createFromToken;
        this.createFromType = b.createFromType;
        this.salt = b.salt;
        this.authSessionId = b.authSessionId;
    }

    public static RefreshTokenDocBuilder<?, ?> builder() {
        return new RefreshTokenDocBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RefreshTokenDoc)) {
            return false;
        }
        RefreshTokenDoc other = (RefreshTokenDoc)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$ttl = this.getTtl();
        Long other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        CredentialDoc this$credential = this.getCredential();
        CredentialDoc other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)((Object)this$credential)).equals((Object)other$credential)) {
            return false;
        }
        Instant this$expireAt = this.getExpireAt();
        Instant other$expireAt = other.getExpireAt();
        if (this$expireAt == null ? other$expireAt != null : !((Object)this$expireAt).equals(other$expireAt)) {
            return false;
        }
        RefreshTokenEntity.Status this$status = this.getStatus();
        RefreshTokenEntity.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        RefreshTokenDoc this$createFromToken = this.getCreateFromToken();
        RefreshTokenDoc other$createFromToken = other.getCreateFromToken();
        if (this$createFromToken == null ? other$createFromToken != null : !((Object)((Object)this$createFromToken)).equals((Object)other$createFromToken)) {
            return false;
        }
        RefreshTokenEntity.CreateFrom this$createFromType = this.getCreateFromType();
        RefreshTokenEntity.CreateFrom other$createFromType = other.getCreateFromType();
        if (this$createFromType == null ? other$createFromType != null : !this$createFromType.equals(other$createFromType)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$authSessionId = this.getAuthSessionId();
        String other$authSessionId = other.getAuthSessionId();
        return !(this$authSessionId == null ? other$authSessionId != null : !this$authSessionId.equals(other$authSessionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RefreshTokenDoc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        CredentialDoc $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)((Object)$credential)).hashCode());
        Instant $expireAt = this.getExpireAt();
        result = result * 59 + ($expireAt == null ? 43 : ((Object)$expireAt).hashCode());
        RefreshTokenEntity.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        RefreshTokenDoc $createFromToken = this.getCreateFromToken();
        result = result * 59 + ($createFromToken == null ? 43 : ((Object)((Object)$createFromToken)).hashCode());
        RefreshTokenEntity.CreateFrom $createFromType = this.getCreateFromType();
        result = result * 59 + ($createFromType == null ? 43 : $createFromType.hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $authSessionId = this.getAuthSessionId();
        result = result * 59 + ($authSessionId == null ? 43 : $authSessionId.hashCode());
        return result;
    }

    public RefreshTokenDoc(CredentialDoc credential, Long ttl, Instant expireAt, RefreshTokenEntity.Status status, RefreshTokenDoc createFromToken, RefreshTokenEntity.CreateFrom createFromType, String salt, String authSessionId) {
        this.credential = credential;
        this.ttl = ttl;
        this.expireAt = expireAt;
        this.status = status;
        this.createFromToken = createFromToken;
        this.createFromType = createFromType;
        this.salt = salt;
        this.authSessionId = authSessionId;
    }

    public RefreshTokenDoc() {
    }

    public CredentialDoc getCredential() {
        return this.credential;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public RefreshTokenEntity.Status getStatus() {
        return this.status;
    }

    public RefreshTokenDoc getCreateFromToken() {
        return this.createFromToken;
    }

    public RefreshTokenEntity.CreateFrom getCreateFromType() {
        return this.createFromType;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getAuthSessionId() {
        return this.authSessionId;
    }

    public void setCredential(CredentialDoc credential) {
        this.credential = credential;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public void setExpireAt(Instant expireAt) {
        this.expireAt = expireAt;
    }

    public void setStatus(RefreshTokenEntity.Status status) {
        this.status = status;
    }

    public void setCreateFromToken(RefreshTokenDoc createFromToken) {
        this.createFromToken = createFromToken;
    }

    public void setCreateFromType(RefreshTokenEntity.CreateFrom createFromType) {
        this.createFromType = createFromType;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setAuthSessionId(String authSessionId) {
        this.authSessionId = authSessionId;
    }

    public String toString() {
        return "RefreshTokenDoc(credential=" + this.getCredential() + ", ttl=" + this.getTtl() + ", expireAt=" + this.getExpireAt() + ", status=" + this.getStatus() + ", createFromToken=" + this.getCreateFromToken() + ", createFromType=" + this.getCreateFromType() + ", salt=" + this.getSalt() + ", authSessionId=" + this.getAuthSessionId() + ")";
    }

    private static final class RefreshTokenDocBuilderImpl
    extends RefreshTokenDocBuilder<RefreshTokenDoc, RefreshTokenDocBuilderImpl> {
        private RefreshTokenDocBuilderImpl() {
        }

        @Override
        protected RefreshTokenDocBuilderImpl self() {
            return this;
        }

        @Override
        public RefreshTokenDoc build() {
            return new RefreshTokenDoc(this);
        }
    }

    public static abstract class RefreshTokenDocBuilder<C extends RefreshTokenDoc, B extends RefreshTokenDocBuilder<C, B>>
    extends BaseDeleteDocument.BaseDeleteDocumentBuilder<C, B> {
        private CredentialDoc credential;
        private Long ttl;
        private Instant expireAt;
        private RefreshTokenEntity.Status status;
        private RefreshTokenDoc createFromToken;
        private RefreshTokenEntity.CreateFrom createFromType;
        private String salt;
        private String authSessionId;

        protected abstract B self();

        public abstract C build();

        public B credential(CredentialDoc credential) {
            this.credential = credential;
            return (B)this.self();
        }

        public B ttl(Long ttl) {
            this.ttl = ttl;
            return (B)this.self();
        }

        public B expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return (B)this.self();
        }

        public B status(RefreshTokenEntity.Status status) {
            this.status = status;
            return (B)this.self();
        }

        public B createFromToken(RefreshTokenDoc createFromToken) {
            this.createFromToken = createFromToken;
            return (B)this.self();
        }

        public B createFromType(RefreshTokenEntity.CreateFrom createFromType) {
            this.createFromType = createFromType;
            return (B)this.self();
        }

        public B salt(String salt) {
            this.salt = salt;
            return (B)this.self();
        }

        public B authSessionId(String authSessionId) {
            this.authSessionId = authSessionId;
            return (B)this.self();
        }

        public String toString() {
            return "RefreshTokenDoc.RefreshTokenDocBuilder(super=" + super.toString() + ", credential=" + this.credential + ", ttl=" + this.ttl + ", expireAt=" + this.expireAt + ", status=" + this.status + ", createFromToken=" + this.createFromToken + ", createFromType=" + this.createFromType + ", salt=" + this.salt + ", authSessionId=" + this.authSessionId + ")";
        }
    }
}

