/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.port;

import com.rcore.database.mongo.commons.query.FindByIdQuery;
import com.rcore.database.mongo.commons.utils.CollectionNameUtils;
import com.rcore.domain.commons.port.dto.SearchResult;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.lib.auth.service.domain.migration.entity.MigrationEntity;
import ru.foodtechlab.lib.auth.service.domain.migration.port.MigrationRepository;
import ru.foodtechlab.lib.auth.service.domain.migration.port.filters.MigrationFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.documents.MigrationDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.manualMigrations.v3_1_7.migration.MigrateToV3_1_7;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.mapper.MigrationMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.query.FindWithFiltersQuery;

@Repository
public class MongoMigrationRepository
implements MigrationRepository {
    private static final String collectionName = CollectionNameUtils.getCollectionName(MigrationDoc.class);
    private final MongoTemplate mongoTemplate;
    private final MigrationMapper mapper;

    public MigrationEntity save(MigrationEntity entity) {
        return this.mapper.inverseMap((MigrationDoc)this.mongoTemplate.save((Object)this.mapper.map(entity), collectionName));
    }

    public Boolean delete(String id) {
        long deleteCount = this.mongoTemplate.remove(FindByIdQuery.of((Object)id).getQuery(), collectionName).getDeletedCount();
        return deleteCount > 0L;
    }

    public Optional<MigrationEntity> findById(String s) {
        return Optional.ofNullable((MigrationDoc)this.mongoTemplate.findById((Object)s, MigrationDoc.class)).map(this.mapper::inverseMap);
    }

    public SearchResult<MigrationEntity> find(MigrationFilters filters) {
        Query query = new FindWithFiltersQuery(filters).getQuery();
        return SearchResult.withItemsAndCount(this.mongoTemplate.find(query, MigrationDoc.class).stream().map(this.mapper::inverseMap).collect(Collectors.toList()), (Long)this.mongoTemplate.count(query.limit(0).skip(0L), MigrationDoc.class));
    }

    public Long count() {
        return this.mongoTemplate.count(new Query(), MigrationDoc.class);
    }

    public MigrationEntity getMigration() {
        Optional<MigrationEntity> opt = this.findById("MigrationEntity");
        if (opt.isPresent()) {
            return opt.get();
        }
        MigrationEntity migrationEntity = new MigrationEntity("MigrationEntity");
        migrationEntity.setVersion(Integer.valueOf(0));
        this.save(migrationEntity);
        return migrationEntity;
    }

    public MigrationEntity runMigration() {
        MigrateToV3_1_7 migrateToV3_1_7 = new MigrateToV3_1_7(this.mongoTemplate, this);
        MigrationEntity migrationEntity = this.getMigration();
        if (migrateToV3_1_7.checkAvailable(migrationEntity).booleanValue()) {
            migrationEntity = migrateToV3_1_7.checkAndRunMigration(migrationEntity);
        }
        return migrationEntity;
    }

    public boolean exist(String s) {
        return false;
    }

    public MongoMigrationRepository(MongoTemplate mongoTemplate, MigrationMapper mapper) {
        this.mongoTemplate = mongoTemplate;
        this.mapper = mapper;
    }
}

