/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.migration.documents;

import java.time.Instant;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class MigrationDoc {
    protected String id = new String();
    protected Integer version;
    protected Instant createdAt = Instant.now();
    protected Instant updatedAt = Instant.now();

    protected MigrationDoc(MigrationDocBuilder<?, ?> b) {
        this.id = b.id;
        this.version = b.version;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
    }

    public static MigrationDocBuilder<?, ?> builder() {
        return new MigrationDocBuilderImpl();
    }

    public MigrationDoc() {
    }

    public MigrationDoc(String id, Integer version, Instant createdAt, Instant updatedAt) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public String getId() {
        return this.id;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    private static final class MigrationDocBuilderImpl
    extends MigrationDocBuilder<MigrationDoc, MigrationDocBuilderImpl> {
        private MigrationDocBuilderImpl() {
        }

        @Override
        protected MigrationDocBuilderImpl self() {
            return this;
        }

        @Override
        public MigrationDoc build() {
            return new MigrationDoc(this);
        }
    }

    public static abstract class MigrationDocBuilder<C extends MigrationDoc, B extends MigrationDocBuilder<C, B>> {
        private String id;
        private Integer version;
        private Instant createdAt;
        private Instant updatedAt;

        protected abstract B self();

        public abstract C build();

        public B id(String id) {
            this.id = id;
            return this.self();
        }

        public B version(Integer version) {
            this.version = version;
            return this.self();
        }

        public B createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        public B updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        public String toString() {
            return "MigrationDoc.MigrationDocBuilder(id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

