/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import com.rcore.domain.commons.port.dto.SearchFilters;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import java.util.ArrayList;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.filter.ConfirmationCodeFilters;

public class FindWithFiltersQuery
extends AbstractExampleQuery {
    private final ConfirmationCodeFilters filters;

    public FindWithFiltersQuery(ConfirmationCodeFilters filters) {
        super((SearchFilters)filters);
        this.filters = filters;
    }

    public Criteria getCriteria() {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        if (StringUtils.hasText((String)this.filters.getAuthSessionId())) {
            criteriaList.add(Criteria.where((String)"authSession.$id").is((Object)new ObjectId(this.filters.getAuthSessionId())));
        }
        if (StringUtils.hasText((String)this.filters.getDeviceId())) {
            criteriaList.add(Criteria.where((String)"deviceId").is((Object)this.filters.getDeviceId()));
        }
        if (StringUtils.hasText((String)this.filters.getQuery())) {
            criteriaList.add(MongoQueryUtils.generateQueryRegEXCriteria((String)this.filters.getQuery(), (String[])new String[]{"email", "phoneNumber"}));
        }
        if (this.filters.getConfirmationCodeDestinationType() != null) {
            criteriaList.add(Criteria.where((String)"confirmationCodeDestinationType").is((Object)this.filters.getConfirmationCodeDestinationType()));
        }
        if (this.filters.getConfirmationStatus() != null) {
            criteriaList.add(Criteria.where((String)"confirmationStatus").is((Object)this.filters.getConfirmationStatus()));
        }
        if (this.filters.getLoginType() != null) {
            criteriaList.add(Criteria.where((String)"loginType").is((Object)this.filters.getLoginType()));
        }
        DeletedCriteria.filterCriteria((Boolean)this.filters.getDeleted()).ifPresent(criteriaList::add);
        return !criteriaList.isEmpty() ? new Criteria().andOperator((Criteria[])criteriaList.toArray(Criteria[]::new)) : new Criteria();
    }
}

