/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.port;

import com.rcore.commons.mapper.ExampleDataMapper;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import java.util.Optional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeRepository;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.filter.ConfirmationCodeFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.mapper.ConfirmationCodeDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.model.ConfirmationCodeDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindCodeBySessionQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindLastNotConfirmedForCredentialQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query.FindWithFiltersQuery;

@Repository
public class MongoConfirmationCodeRepository
extends AbstractMongoSafeDeleteRepository<String, ConfirmationCodeEntity, ConfirmationCodeDoc, ConfirmationCodeFilters>
implements ConfirmationCodeRepository {
    public MongoConfirmationCodeRepository(ConfirmationCodeDocMapper mapper, MongoTemplate mongoTemplate) {
        super(ConfirmationCodeDoc.class, (ExampleDataMapper)mapper, mongoTemplate);
    }

    public Optional<ConfirmationCodeEntity> findLastNotConfirmedForCredential(LoginDetails loginDetails, String deviceToken) {
        return Optional.ofNullable((ConfirmationCodeDoc)((Object)this.mongoTemplate.findOne(FindLastNotConfirmedForCredentialQuery.of(loginDetails, deviceToken).getQuery(), ConfirmationCodeDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }

    protected AbstractExampleQuery getSearchQuery(ConfirmationCodeFilters filters) {
        return new FindWithFiltersQuery(filters);
    }

    public Long count() {
        return this.mongoTemplate.count(new Query(), ConfirmationCodeDoc.class);
    }

    public Optional<ConfirmationCodeEntity> findCodeBySession(String authSessionId) {
        Query query = FindCodeBySessionQuery.of(authSessionId).getQuery();
        return Optional.ofNullable((ConfirmationCodeDoc)((Object)this.mongoTemplate.findOne(query, ConfirmationCodeDoc.class))).map(arg_0 -> ((ExampleDataMapper)this.mapper).inverseMap(arg_0));
    }
}

