/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.springframework.data.mongodb.core.query.Criteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;

public class FindByClientInfoInDayQuery
implements ExampleQuery {
    private final ClientInfo clientInfo;

    public Criteria getCriteria() {
        Instant time = Instant.now().minus(1L, ChronoUnit.DAYS);
        return new Criteria().andOperator(new Criteria[]{this.clientInfo.getIp() != null ? Criteria.where((String)"ipV4").is((Object)this.clientInfo.getIp()) : new Criteria(), this.clientInfo.getDeviceId() != null ? Criteria.where((String)"deviceId").is((Object)this.clientInfo.getDeviceId()) : new Criteria(), this.clientInfo.getApplication() != null ? Criteria.where((String)"applicationDetails.name").is((Object)this.clientInfo.getApplication()) : new Criteria(), this.clientInfo.getPlatform() != null ? Criteria.where((String)"applicationDetails.platform").is((Object)this.clientInfo.getPlatform()) : new Criteria(), this.clientInfo.getVersionName() != null ? Criteria.where((String)"applicationDetails.version").is((Object)this.clientInfo.getVersionName()) : new Criteria(), this.clientInfo.getIp() != null ? Criteria.where((String)"status").ne((Object)AuthSessionEntity.Status.INIT_ERROR) : new Criteria(), Criteria.where((String)"createdAt").gte((Object)time), IsDeletedCriteria.getNotDeletedCriteria()});
    }

    private FindByClientInfoInDayQuery(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public static FindByClientInfoInDayQuery of(ClientInfo clientInfo) {
        return new FindByClientInfoInDayQuery(clientInfo);
    }
}

