/*
 * Decompiled with CFR 0.152.
 */
package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model;

import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import java.time.Instant;
import java.util.List;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.AccessTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.RefreshTokenDoc;

@Document
@CompoundIndexes(value={@CompoundIndex(name="ipv4_type_createdAt_isDeleted", def="{ipV4: 1, type: 1, createdAt: 1, isDeleted: 1}"), @CompoundIndex(name="status_username_deviceId_isDeleted", def="{'status': 1, 'username': 1, 'deviceId': 1, 'isDeleted': 1}"), @CompoundIndex(name="username_type_createdAt_status_isDeleted", def="{'username': 1, 'type': 1, 'createdAt': 1, 'status': 1, 'isDeleted': 1}"), @CompoundIndex(name="deviceId_type_createdAt_isDeleted", def="{'deviceId': 1, 'type': 1, 'createdAt': 1, 'isDeleted': 1}")})
public class AuthSessionDoc
extends BaseDeleteDocument {
    private Boolean isRegistrationAllowed;
    private ConfirmationCodeEntity.Type confirmationCodeType;
    private Long ttl;
    private Instant expireAt;
    @DBRef
    private CredentialDoc credential;
    @DBRef
    private RoleDoc role;
    private AuthSessionEntity.Status status;
    private AuthSessionEntity.Type type;
    private AuthSessionEntity.LoginType loginType;
    private List<String> errors;
    private Long authSessionLoginConfirmAttemptsLimit;
    private Long authSessionLoginConfirmAttempts;
    private Long authSessionLoginInitAttempts;
    @Indexed
    private String phoneNumber;
    private String isoTwoLetterCountryCode;
    @Indexed
    private String username;
    @Indexed
    private String email;
    private String deviceId;
    private String ipV4;
    private ApplicationDetails applicationDetails;
    @DBRef
    private AccessTokenDoc accessToken;
    @DBRef
    private RefreshTokenDoc refreshToken;
    @Version
    private Long version;

    @Field(value="isDeleted")
    public boolean isDeleted() {
        return super.isDeleted();
    }

    protected AuthSessionDoc(AuthSessionDocBuilder<?, ?> b) {
        super(b);
        this.isRegistrationAllowed = b.isRegistrationAllowed;
        this.confirmationCodeType = b.confirmationCodeType;
        this.ttl = b.ttl;
        this.expireAt = b.expireAt;
        this.credential = b.credential;
        this.role = b.role;
        this.status = b.status;
        this.type = b.type;
        this.loginType = b.loginType;
        this.errors = b.errors;
        this.authSessionLoginConfirmAttemptsLimit = b.authSessionLoginConfirmAttemptsLimit;
        this.authSessionLoginConfirmAttempts = b.authSessionLoginConfirmAttempts;
        this.authSessionLoginInitAttempts = b.authSessionLoginInitAttempts;
        this.phoneNumber = b.phoneNumber;
        this.isoTwoLetterCountryCode = b.isoTwoLetterCountryCode;
        this.username = b.username;
        this.email = b.email;
        this.deviceId = b.deviceId;
        this.ipV4 = b.ipV4;
        this.applicationDetails = b.applicationDetails;
        this.accessToken = b.accessToken;
        this.refreshToken = b.refreshToken;
        this.version = b.version;
    }

    public static AuthSessionDocBuilder<?, ?> builder() {
        return new AuthSessionDocBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthSessionDoc)) {
            return false;
        }
        AuthSessionDoc other = (AuthSessionDoc)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isRegistrationAllowed = this.getIsRegistrationAllowed();
        Boolean other$isRegistrationAllowed = other.getIsRegistrationAllowed();
        if (this$isRegistrationAllowed == null ? other$isRegistrationAllowed != null : !((Object)this$isRegistrationAllowed).equals(other$isRegistrationAllowed)) {
            return false;
        }
        Long this$ttl = this.getTtl();
        Long other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Long this$authSessionLoginConfirmAttemptsLimit = this.getAuthSessionLoginConfirmAttemptsLimit();
        Long other$authSessionLoginConfirmAttemptsLimit = other.getAuthSessionLoginConfirmAttemptsLimit();
        if (this$authSessionLoginConfirmAttemptsLimit == null ? other$authSessionLoginConfirmAttemptsLimit != null : !((Object)this$authSessionLoginConfirmAttemptsLimit).equals(other$authSessionLoginConfirmAttemptsLimit)) {
            return false;
        }
        Long this$authSessionLoginConfirmAttempts = this.getAuthSessionLoginConfirmAttempts();
        Long other$authSessionLoginConfirmAttempts = other.getAuthSessionLoginConfirmAttempts();
        if (this$authSessionLoginConfirmAttempts == null ? other$authSessionLoginConfirmAttempts != null : !((Object)this$authSessionLoginConfirmAttempts).equals(other$authSessionLoginConfirmAttempts)) {
            return false;
        }
        Long this$authSessionLoginInitAttempts = this.getAuthSessionLoginInitAttempts();
        Long other$authSessionLoginInitAttempts = other.getAuthSessionLoginInitAttempts();
        if (this$authSessionLoginInitAttempts == null ? other$authSessionLoginInitAttempts != null : !((Object)this$authSessionLoginInitAttempts).equals(other$authSessionLoginInitAttempts)) {
            return false;
        }
        Long this$version = this.getVersion();
        Long other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        ConfirmationCodeEntity.Type this$confirmationCodeType = this.getConfirmationCodeType();
        ConfirmationCodeEntity.Type other$confirmationCodeType = other.getConfirmationCodeType();
        if (this$confirmationCodeType == null ? other$confirmationCodeType != null : !this$confirmationCodeType.equals(other$confirmationCodeType)) {
            return false;
        }
        Instant this$expireAt = this.getExpireAt();
        Instant other$expireAt = other.getExpireAt();
        if (this$expireAt == null ? other$expireAt != null : !((Object)this$expireAt).equals(other$expireAt)) {
            return false;
        }
        CredentialDoc this$credential = this.getCredential();
        CredentialDoc other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)((Object)this$credential)).equals((Object)other$credential)) {
            return false;
        }
        RoleDoc this$role = this.getRole();
        RoleDoc other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        AuthSessionEntity.Status this$status = this.getStatus();
        AuthSessionEntity.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        AuthSessionEntity.Type this$type = this.getType();
        AuthSessionEntity.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        AuthSessionEntity.LoginType this$loginType = this.getLoginType();
        AuthSessionEntity.LoginType other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !this$loginType.equals(other$loginType)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$isoTwoLetterCountryCode = this.getIsoTwoLetterCountryCode();
        String other$isoTwoLetterCountryCode = other.getIsoTwoLetterCountryCode();
        if (this$isoTwoLetterCountryCode == null ? other$isoTwoLetterCountryCode != null : !this$isoTwoLetterCountryCode.equals(other$isoTwoLetterCountryCode)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        String this$ipV4 = this.getIpV4();
        String other$ipV4 = other.getIpV4();
        if (this$ipV4 == null ? other$ipV4 != null : !this$ipV4.equals(other$ipV4)) {
            return false;
        }
        ApplicationDetails this$applicationDetails = this.getApplicationDetails();
        ApplicationDetails other$applicationDetails = other.getApplicationDetails();
        if (this$applicationDetails == null ? other$applicationDetails != null : !((Object)this$applicationDetails).equals(other$applicationDetails)) {
            return false;
        }
        AccessTokenDoc this$accessToken = this.getAccessToken();
        AccessTokenDoc other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !((Object)((Object)this$accessToken)).equals((Object)other$accessToken)) {
            return false;
        }
        RefreshTokenDoc this$refreshToken = this.getRefreshToken();
        RefreshTokenDoc other$refreshToken = other.getRefreshToken();
        return !(this$refreshToken == null ? other$refreshToken != null : !((Object)((Object)this$refreshToken)).equals((Object)other$refreshToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthSessionDoc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isRegistrationAllowed = this.getIsRegistrationAllowed();
        result = result * 59 + ($isRegistrationAllowed == null ? 43 : ((Object)$isRegistrationAllowed).hashCode());
        Long $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Long $authSessionLoginConfirmAttemptsLimit = this.getAuthSessionLoginConfirmAttemptsLimit();
        result = result * 59 + ($authSessionLoginConfirmAttemptsLimit == null ? 43 : ((Object)$authSessionLoginConfirmAttemptsLimit).hashCode());
        Long $authSessionLoginConfirmAttempts = this.getAuthSessionLoginConfirmAttempts();
        result = result * 59 + ($authSessionLoginConfirmAttempts == null ? 43 : ((Object)$authSessionLoginConfirmAttempts).hashCode());
        Long $authSessionLoginInitAttempts = this.getAuthSessionLoginInitAttempts();
        result = result * 59 + ($authSessionLoginInitAttempts == null ? 43 : ((Object)$authSessionLoginInitAttempts).hashCode());
        Long $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        ConfirmationCodeEntity.Type $confirmationCodeType = this.getConfirmationCodeType();
        result = result * 59 + ($confirmationCodeType == null ? 43 : $confirmationCodeType.hashCode());
        Instant $expireAt = this.getExpireAt();
        result = result * 59 + ($expireAt == null ? 43 : ((Object)$expireAt).hashCode());
        CredentialDoc $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)((Object)$credential)).hashCode());
        RoleDoc $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        AuthSessionEntity.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        AuthSessionEntity.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        AuthSessionEntity.LoginType $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : $loginType.hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $isoTwoLetterCountryCode = this.getIsoTwoLetterCountryCode();
        result = result * 59 + ($isoTwoLetterCountryCode == null ? 43 : $isoTwoLetterCountryCode.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        String $ipV4 = this.getIpV4();
        result = result * 59 + ($ipV4 == null ? 43 : $ipV4.hashCode());
        ApplicationDetails $applicationDetails = this.getApplicationDetails();
        result = result * 59 + ($applicationDetails == null ? 43 : ((Object)$applicationDetails).hashCode());
        AccessTokenDoc $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : ((Object)((Object)$accessToken)).hashCode());
        RefreshTokenDoc $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : ((Object)((Object)$refreshToken)).hashCode());
        return result;
    }

    public AuthSessionDoc(Boolean isRegistrationAllowed, ConfirmationCodeEntity.Type confirmationCodeType, Long ttl, Instant expireAt, CredentialDoc credential, RoleDoc role, AuthSessionEntity.Status status, AuthSessionEntity.Type type, AuthSessionEntity.LoginType loginType, List<String> errors, Long authSessionLoginConfirmAttemptsLimit, Long authSessionLoginConfirmAttempts, Long authSessionLoginInitAttempts, String phoneNumber, String isoTwoLetterCountryCode, String username, String email, String deviceId, String ipV4, ApplicationDetails applicationDetails, AccessTokenDoc accessToken, RefreshTokenDoc refreshToken, Long version) {
        this.isRegistrationAllowed = isRegistrationAllowed;
        this.confirmationCodeType = confirmationCodeType;
        this.ttl = ttl;
        this.expireAt = expireAt;
        this.credential = credential;
        this.role = role;
        this.status = status;
        this.type = type;
        this.loginType = loginType;
        this.errors = errors;
        this.authSessionLoginConfirmAttemptsLimit = authSessionLoginConfirmAttemptsLimit;
        this.authSessionLoginConfirmAttempts = authSessionLoginConfirmAttempts;
        this.authSessionLoginInitAttempts = authSessionLoginInitAttempts;
        this.phoneNumber = phoneNumber;
        this.isoTwoLetterCountryCode = isoTwoLetterCountryCode;
        this.username = username;
        this.email = email;
        this.deviceId = deviceId;
        this.ipV4 = ipV4;
        this.applicationDetails = applicationDetails;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.version = version;
    }

    public AuthSessionDoc() {
    }

    public Boolean getIsRegistrationAllowed() {
        return this.isRegistrationAllowed;
    }

    public ConfirmationCodeEntity.Type getConfirmationCodeType() {
        return this.confirmationCodeType;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public Instant getExpireAt() {
        return this.expireAt;
    }

    public CredentialDoc getCredential() {
        return this.credential;
    }

    public RoleDoc getRole() {
        return this.role;
    }

    public AuthSessionEntity.Status getStatus() {
        return this.status;
    }

    public AuthSessionEntity.Type getType() {
        return this.type;
    }

    public AuthSessionEntity.LoginType getLoginType() {
        return this.loginType;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Long getAuthSessionLoginConfirmAttemptsLimit() {
        return this.authSessionLoginConfirmAttemptsLimit;
    }

    public Long getAuthSessionLoginConfirmAttempts() {
        return this.authSessionLoginConfirmAttempts;
    }

    public Long getAuthSessionLoginInitAttempts() {
        return this.authSessionLoginInitAttempts;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getIsoTwoLetterCountryCode() {
        return this.isoTwoLetterCountryCode;
    }

    public String getUsername() {
        return this.username;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getIpV4() {
        return this.ipV4;
    }

    public ApplicationDetails getApplicationDetails() {
        return this.applicationDetails;
    }

    public AccessTokenDoc getAccessToken() {
        return this.accessToken;
    }

    public RefreshTokenDoc getRefreshToken() {
        return this.refreshToken;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setIsRegistrationAllowed(Boolean isRegistrationAllowed) {
        this.isRegistrationAllowed = isRegistrationAllowed;
    }

    public void setConfirmationCodeType(ConfirmationCodeEntity.Type confirmationCodeType) {
        this.confirmationCodeType = confirmationCodeType;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public void setExpireAt(Instant expireAt) {
        this.expireAt = expireAt;
    }

    public void setCredential(CredentialDoc credential) {
        this.credential = credential;
    }

    public void setRole(RoleDoc role) {
        this.role = role;
    }

    public void setStatus(AuthSessionEntity.Status status) {
        this.status = status;
    }

    public void setType(AuthSessionEntity.Type type) {
        this.type = type;
    }

    public void setLoginType(AuthSessionEntity.LoginType loginType) {
        this.loginType = loginType;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void setAuthSessionLoginConfirmAttemptsLimit(Long authSessionLoginConfirmAttemptsLimit) {
        this.authSessionLoginConfirmAttemptsLimit = authSessionLoginConfirmAttemptsLimit;
    }

    public void setAuthSessionLoginConfirmAttempts(Long authSessionLoginConfirmAttempts) {
        this.authSessionLoginConfirmAttempts = authSessionLoginConfirmAttempts;
    }

    public void setAuthSessionLoginInitAttempts(Long authSessionLoginInitAttempts) {
        this.authSessionLoginInitAttempts = authSessionLoginInitAttempts;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setIsoTwoLetterCountryCode(String isoTwoLetterCountryCode) {
        this.isoTwoLetterCountryCode = isoTwoLetterCountryCode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setIpV4(String ipV4) {
        this.ipV4 = ipV4;
    }

    public void setApplicationDetails(ApplicationDetails applicationDetails) {
        this.applicationDetails = applicationDetails;
    }

    public void setAccessToken(AccessTokenDoc accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(RefreshTokenDoc refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String toString() {
        return "AuthSessionDoc(isRegistrationAllowed=" + this.getIsRegistrationAllowed() + ", confirmationCodeType=" + this.getConfirmationCodeType() + ", ttl=" + this.getTtl() + ", expireAt=" + this.getExpireAt() + ", credential=" + this.getCredential() + ", role=" + this.getRole() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", loginType=" + this.getLoginType() + ", errors=" + this.getErrors() + ", authSessionLoginConfirmAttemptsLimit=" + this.getAuthSessionLoginConfirmAttemptsLimit() + ", authSessionLoginConfirmAttempts=" + this.getAuthSessionLoginConfirmAttempts() + ", authSessionLoginInitAttempts=" + this.getAuthSessionLoginInitAttempts() + ", phoneNumber=" + this.getPhoneNumber() + ", isoTwoLetterCountryCode=" + this.getIsoTwoLetterCountryCode() + ", username=" + this.getUsername() + ", email=" + this.getEmail() + ", deviceId=" + this.getDeviceId() + ", ipV4=" + this.getIpV4() + ", applicationDetails=" + this.getApplicationDetails() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", version=" + this.getVersion() + ")";
    }

    private static final class AuthSessionDocBuilderImpl
    extends AuthSessionDocBuilder<AuthSessionDoc, AuthSessionDocBuilderImpl> {
        private AuthSessionDocBuilderImpl() {
        }

        @Override
        protected AuthSessionDocBuilderImpl self() {
            return this;
        }

        @Override
        public AuthSessionDoc build() {
            return new AuthSessionDoc(this);
        }
    }

    public static abstract class AuthSessionDocBuilder<C extends AuthSessionDoc, B extends AuthSessionDocBuilder<C, B>>
    extends BaseDeleteDocument.BaseDeleteDocumentBuilder<C, B> {
        private Boolean isRegistrationAllowed;
        private ConfirmationCodeEntity.Type confirmationCodeType;
        private Long ttl;
        private Instant expireAt;
        private CredentialDoc credential;
        private RoleDoc role;
        private AuthSessionEntity.Status status;
        private AuthSessionEntity.Type type;
        private AuthSessionEntity.LoginType loginType;
        private List<String> errors;
        private Long authSessionLoginConfirmAttemptsLimit;
        private Long authSessionLoginConfirmAttempts;
        private Long authSessionLoginInitAttempts;
        private String phoneNumber;
        private String isoTwoLetterCountryCode;
        private String username;
        private String email;
        private String deviceId;
        private String ipV4;
        private ApplicationDetails applicationDetails;
        private AccessTokenDoc accessToken;
        private RefreshTokenDoc refreshToken;
        private Long version;

        protected abstract B self();

        public abstract C build();

        public B isRegistrationAllowed(Boolean isRegistrationAllowed) {
            this.isRegistrationAllowed = isRegistrationAllowed;
            return (B)this.self();
        }

        public B confirmationCodeType(ConfirmationCodeEntity.Type confirmationCodeType) {
            this.confirmationCodeType = confirmationCodeType;
            return (B)this.self();
        }

        public B ttl(Long ttl) {
            this.ttl = ttl;
            return (B)this.self();
        }

        public B expireAt(Instant expireAt) {
            this.expireAt = expireAt;
            return (B)this.self();
        }

        public B credential(CredentialDoc credential) {
            this.credential = credential;
            return (B)this.self();
        }

        public B role(RoleDoc role) {
            this.role = role;
            return (B)this.self();
        }

        public B status(AuthSessionEntity.Status status) {
            this.status = status;
            return (B)this.self();
        }

        public B type(AuthSessionEntity.Type type) {
            this.type = type;
            return (B)this.self();
        }

        public B loginType(AuthSessionEntity.LoginType loginType) {
            this.loginType = loginType;
            return (B)this.self();
        }

        public B errors(List<String> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        public B authSessionLoginConfirmAttemptsLimit(Long authSessionLoginConfirmAttemptsLimit) {
            this.authSessionLoginConfirmAttemptsLimit = authSessionLoginConfirmAttemptsLimit;
            return (B)this.self();
        }

        public B authSessionLoginConfirmAttempts(Long authSessionLoginConfirmAttempts) {
            this.authSessionLoginConfirmAttempts = authSessionLoginConfirmAttempts;
            return (B)this.self();
        }

        public B authSessionLoginInitAttempts(Long authSessionLoginInitAttempts) {
            this.authSessionLoginInitAttempts = authSessionLoginInitAttempts;
            return (B)this.self();
        }

        public B phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return (B)this.self();
        }

        public B isoTwoLetterCountryCode(String isoTwoLetterCountryCode) {
            this.isoTwoLetterCountryCode = isoTwoLetterCountryCode;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        public B deviceId(String deviceId) {
            this.deviceId = deviceId;
            return (B)this.self();
        }

        public B ipV4(String ipV4) {
            this.ipV4 = ipV4;
            return (B)this.self();
        }

        public B applicationDetails(ApplicationDetails applicationDetails) {
            this.applicationDetails = applicationDetails;
            return (B)this.self();
        }

        public B accessToken(AccessTokenDoc accessToken) {
            this.accessToken = accessToken;
            return (B)this.self();
        }

        public B refreshToken(RefreshTokenDoc refreshToken) {
            this.refreshToken = refreshToken;
            return (B)this.self();
        }

        public B version(Long version) {
            this.version = version;
            return (B)this.self();
        }

        public String toString() {
            return "AuthSessionDoc.AuthSessionDocBuilder(super=" + super.toString() + ", isRegistrationAllowed=" + this.isRegistrationAllowed + ", confirmationCodeType=" + this.confirmationCodeType + ", ttl=" + this.ttl + ", expireAt=" + this.expireAt + ", credential=" + this.credential + ", role=" + this.role + ", status=" + this.status + ", type=" + this.type + ", loginType=" + this.loginType + ", errors=" + this.errors + ", authSessionLoginConfirmAttemptsLimit=" + this.authSessionLoginConfirmAttemptsLimit + ", authSessionLoginConfirmAttempts=" + this.authSessionLoginConfirmAttempts + ", authSessionLoginInitAttempts=" + this.authSessionLoginInitAttempts + ", phoneNumber=" + this.phoneNumber + ", isoTwoLetterCountryCode=" + this.isoTwoLetterCountryCode + ", username=" + this.username + ", email=" + this.email + ", deviceId=" + this.deviceId + ", ipV4=" + this.ipV4 + ", applicationDetails=" + this.applicationDetails + ", accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", version=" + this.version + ")";
        }
    }

    public static class ApplicationDetails {
        private String name;
        private String platform;
        private String versionName;

        public static ApplicationDetailsBuilder builder() {
            return new ApplicationDetailsBuilder();
        }

        public ApplicationDetails(String name, String platform, String versionName) {
            this.name = name;
            this.platform = platform;
            this.versionName = versionName;
        }

        public ApplicationDetails() {
        }

        public String getName() {
            return this.name;
        }

        public String getPlatform() {
            return this.platform;
        }

        public String getVersionName() {
            return this.versionName;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationDetails)) {
                return false;
            }
            ApplicationDetails other = (ApplicationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            String this$versionName = this.getVersionName();
            String other$versionName = other.getVersionName();
            return !(this$versionName == null ? other$versionName != null : !this$versionName.equals(other$versionName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplicationDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            String $versionName = this.getVersionName();
            result = result * 59 + ($versionName == null ? 43 : $versionName.hashCode());
            return result;
        }

        public String toString() {
            return "AuthSessionDoc.ApplicationDetails(name=" + this.getName() + ", platform=" + this.getPlatform() + ", versionName=" + this.getVersionName() + ")";
        }

        public static class ApplicationDetailsBuilder {
            private String name;
            private String platform;
            private String versionName;

            ApplicationDetailsBuilder() {
            }

            public ApplicationDetailsBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ApplicationDetailsBuilder platform(String platform) {
                this.platform = platform;
                return this;
            }

            public ApplicationDetailsBuilder versionName(String versionName) {
                this.versionName = versionName;
                return this;
            }

            public ApplicationDetails build() {
                return new ApplicationDetails(this.name, this.platform, this.versionName);
            }

            public String toString() {
                return "AuthSessionDoc.ApplicationDetails.ApplicationDetailsBuilder(name=" + this.name + ", platform=" + this.platform + ", versionName=" + this.versionName + ")";
            }
        }
    }
}

