package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.query.ExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class FindAccessTokensByRefreshTokenQuery implements ExampleQuery {

    private final String refreshTokenId;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("createByRefreshToken.$id").is(new ObjectId(refreshTokenId)),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
