package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractModifyQuery;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;

@RequiredArgsConstructor(staticName = "of")
public class DeactivateAllAccessTokenByRefreshTokenIdQuery extends AbstractModifyQuery {

    private final String refreshTokenId;

    @Override
    public Update getUpdate() {
        return Update.update("status", RefreshTokenEntity.Status.INACTIVE);
    }

    @Override
    public FindAndModifyOptions getModifyOptions() {
        return FindAndModifyOptions.options().returnNew(true);
    }

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("createByRefreshToken.$id").is( new ObjectId(refreshTokenId)),
                Criteria.where("status").ne(RefreshTokenEntity.Status.EXPIRED),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
