package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model.CredentialDoc;

import java.time.Instant;

@EqualsAndHashCode(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Document
@Data
@CompoundIndexes({
        @CompoundIndex(name = "credentialId_status_isDeleted", def = "{'credential.$id': 1, 'status': 1, 'isDeleted': 1}"),
        @CompoundIndex(name = "_id_isDeleted", def = "{'_id': 1, 'isDeleted': 1}"),
        @CompoundIndex(name = "userId_status_expireAt_isDeleted", def = "{'userId': 1, 'status': 1, 'expireAt': 1, 'isDeleted': 1}"),
        @CompoundIndex(name = "isDeleted_credentialId_status", def = "{'isDeleted': 1, 'credential.$id': 1, 'status': 1}")
})
public class RefreshTokenDoc extends BaseDeleteDocument {

    @DBRef
    private CredentialDoc credential;
    private Long ttl;
    private Instant expireAt;
    private RefreshTokenEntity.Status status;
    @DBRef
    private RefreshTokenDoc createFromToken;
    private RefreshTokenEntity.CreateFrom createFromType;
    private String salt;
    private String authSessionId;

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
