package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.filters.RoleAccessFilters;

import java.util.ArrayList;
import java.util.List;

public class FindRoleAccessWithFiltersQuery extends AbstractExampleQuery {
    private final RoleAccessFilters filters;

    public FindRoleAccessWithFiltersQuery(RoleAccessFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        List<Criteria> criteriaList = new ArrayList<>(4);

        DeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaList::add);

        if (StringUtils.hasText(filters.getQuery())) {
            criteriaList.add(MongoQueryUtils.generateQueryRegEXCriteria(filters.getQuery(),
                    "serviceName",
                    "requestPathPattern"
            ));
        }

        if (filters.getMethod() != null) {
            criteriaList.add(Criteria.where("method").is(filters.getMethod()));
        }
        if (criteriaList.isEmpty())
            return new Criteria();
        else
            return new Criteria().andOperator(criteriaList.toArray(Criteria[]::new));
    }
}
