package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.role.port.filters.RoleFilters;

import java.util.HashSet;
import java.util.Set;

public class FindRoleWithFiltersQuery extends AbstractExampleQuery {
    private final RoleFilters filters;

    public FindRoleWithFiltersQuery(RoleFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        Criteria res = new Criteria();
        Set<Criteria> criteriaSet = new HashSet<>();

        IsDeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaSet::add);

        if (StringUtils.hasText(filters.getQuery()))
            criteriaSet.add(MongoQueryUtils.generateQueryRegEXCriteria(filters.getQuery(), "name", "code"));

        if (filters.getIsRegistrationAllowed() != null)
            criteriaSet.add(Criteria.where("isRegistrationAllowed").is(filters.getIsRegistrationAllowed()));

        if (filters.getAccessIds() != null && !filters.getAccessIds().isEmpty())
            criteriaSet.add(Criteria.where("accessIds").all(filters.getAccessIds()));

        if (!criteriaSet.isEmpty()) {
            res = new Criteria().andOperator(criteriaSet.toArray(Criteria[]::new));
        }
        return res;
    }
}
