package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.port;

import com.rcore.database.mongo.commons.utils.CollectionNameUtils;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.preference.entity.ServicePreferenceEntity;
import ru.foodtechlab.lib.auth.service.domain.preference.port.ServicePreferenceRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.mapper.ServicePreferenceDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.preference.model.ServicePreferenceDoc;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class MongoServicePreferenceRepository implements ServicePreferenceRepository {

    private static final String collectionName = CollectionNameUtils.getCollectionName(ServicePreferenceDoc.class);
    private final MongoTemplate mongoTemplate;
    private final ServicePreferenceDocMapper servicePreferenceDocMapper = new ServicePreferenceDocMapper();

    @Override
    public Optional<ServicePreferenceEntity> findOne() {
        return Optional.ofNullable(mongoTemplate.findOne(new Query(), ServicePreferenceDoc.class))
                .map(servicePreferenceDocMapper::inverseMap);
    }

    @Override
    public ServicePreferenceEntity save(ServicePreferenceEntity entity) {
        mongoTemplate.save(servicePreferenceDocMapper.map(entity), collectionName);
        return entity;
    }
}
