package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class FindByUsernameQuery implements ExampleQuery {

    private final String username;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("username").is(username),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
