package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class FindByPhoneQuery implements ExampleQuery {

    private final String phone;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("phoneNumber.value").is(phone),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
