package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.model;

import lombok.*;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeDestinationType;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.Email;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.PhoneNumber;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;

import java.util.List;

@CompoundIndexes({
        @CompoundIndex(name = "username", def = "{'username': 1}"),
        @CompoundIndex(name = "email", def = "{'email': 1}"),
        @CompoundIndex(name = "phoneNumberValue", def = "{'phoneNumber.value': 1}"),
        @CompoundIndex(name = "username_email_phoneNumberValue", def = "{'username': 1, 'email': 1, 'phoneNumber.value': 1}")
})
@NoArgsConstructor
@SuperBuilder
@Document
@Getter
@Setter
public class CredentialDoc extends BaseDeleteDocument {
    @Indexed
    private String username;
    private String password;
    private PhoneNumber phoneNumber;
    private Email email;
    @Indexed
    private List<Role> roles;
    @Indexed
    private Boolean isBlocked;
    @Indexed
    private ConfirmationCodeDestinationType confirmationCodeDestinationType;
    private String personalConfirmationCode;
    @Indexed
    @Builder.Default
    private ConfirmationCodeEntity.Type confirmationCodeType = ConfirmationCodeEntity.Type.ONE_TIME;

    @AllArgsConstructor
    @NoArgsConstructor
    @Data
    @Builder
    public static class Role {

        @DBRef
        private RoleDoc role;
        private boolean isBlocked;
    }

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }

}
