package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeDestinationType;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model.AuthSessionDoc;

import java.time.Instant;

@EqualsAndHashCode(callSuper = true)
@Document
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
@Data
public class ConfirmationCodeDoc extends BaseDeleteDocument {
    private String code;
    private String message;
    private String header;
    private String webhookProviderUrl;

    @DBRef
    private AuthSessionDoc authSession;
    private ConfirmationCodeDestinationType confirmationCodeDestinationType;
    /**
     * Статус подтверждения кода
     */
    private ConfirmationCodeEntity.ConfirmationStatus confirmationStatus;
    private Instant confirmationAt;
    private Instant expiredAt;
    private Long ttl;
    private String deviceId;
    @Indexed
    private String phoneNumber;
    @Indexed
    private String email;
    private AuthSessionEntity.LoginType loginType;
    private ConfirmationCodeEntity.Type type;

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
