package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;

@RequiredArgsConstructor(staticName = "of")
public class FindPendingConfirmationByLoginDetailsQuery implements ExampleQuery {

    private final LoginDetails loginDetails;
    private final String deviceId;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("status").is(AuthSessionEntity.Status.PENDING),
                loginDetails.getEmail() != null ? Criteria.where("email").is(loginDetails.getEmail().toLowerCase()) : new Criteria(),
                loginDetails.getPhoneNumber() != null ? Criteria.where("phoneNumber").is(loginDetails.getPhoneNumber().getValue()) : new Criteria(),
                loginDetails.getUsername() != null ? Criteria.where("username").is(loginDetails.getUsername()) : new Criteria(),
                Criteria.where("deviceId").is(deviceId),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
