package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import com.rcore.database.mongo.commons.query.IsDeletedQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

@RequiredArgsConstructor(staticName = "of")
public class FindByLoginDetailsAndTypeInDayQuery implements ExampleQuery {

    private final LoginDetails loginDetails;
    private final AuthSessionEntity.Type type;

    @Override
    public Criteria getCriteria() {
        var time = Instant.now().minus(1, ChronoUnit.HOURS);
        return new Criteria().andOperator(
                loginDetails.getEmail() != null ? Criteria.where("email").is(loginDetails.getEmail().toLowerCase()) : new Criteria(),
                loginDetails.getPhoneNumber() != null ? Criteria.where("phoneNumber").is(loginDetails.getPhoneNumber().getValue()) : new Criteria(),
                loginDetails.getUsername() != null ? Criteria.where("username").is(loginDetails.getUsername()) : new Criteria(),
                Criteria.where("type").is(type),
                Criteria.where("createdAt").gte(time),
                Criteria.where("status").ne(AuthSessionEntity.Status.INIT_ERROR),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
