package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

@RequiredArgsConstructor(staticName = "of")
public class FindByClientInfoInDayQuery implements ExampleQuery {

    private final ClientInfo clientInfo;

    @Override
    public Criteria getCriteria() {
        var time = Instant.now().minus(1, ChronoUnit.DAYS);
        return new Criteria().andOperator(
                clientInfo.getIp() != null ? Criteria.where("ipV4").is(clientInfo.getIp()) : new Criteria(),
                clientInfo.getDeviceId() != null ? Criteria.where("deviceId").is(clientInfo.getDeviceId()) : new Criteria(),
                clientInfo.getApplication() != null ? Criteria.where("applicationDetails.name").is(clientInfo.getApplication()) : new Criteria(),
                clientInfo.getPlatform() != null ? Criteria.where("applicationDetails.platform").is(clientInfo.getPlatform()) : new Criteria(),
                clientInfo.getVersionName() != null ? Criteria.where("applicationDetails.version").is(clientInfo.getVersionName()) : new Criteria(),
                clientInfo.getIp() != null ? Criteria.where("status").ne(AuthSessionEntity.Status.INIT_ERROR) : new Criteria(),
                Criteria.where("createdAt").gte(time),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
