package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.auth.port.AuthorizationSessionRepository;
import ru.foodtechlab.lib.auth.service.domain.auth.port.filter.AuthorizationSessionFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.mapper.AuthorizationSessionDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.model.AuthSessionDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.authorizationSession.query.*;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Repository
public class MongoAuthorizationSessionRepository extends AbstractMongoSafeDeleteRepository<String, AuthSessionEntity, AuthSessionDoc, AuthorizationSessionFilters>
        implements AuthorizationSessionRepository {

    public MongoAuthorizationSessionRepository(AuthorizationSessionDocMapper mapper, MongoTemplate mongoTemplate) {
        super(AuthSessionDoc.class, mapper, mongoTemplate);
    }

    @Override
    public Optional<AuthSessionEntity> findPendingByAuthData(LoginDetails loginDetails, ClientInfo clientInfo) {
        var query = FindPendingConfirmationByLoginDetailsQuery.of(loginDetails, clientInfo.getDeviceId()).getQuery();
        return Optional.ofNullable(mongoTemplate.findOne(query, AuthSessionDoc.class))
                .map(mapper::inverseMap);
    }

    @Override
    public Long countSessionsByDeviceTokenAndTypeInDay(String deviceId, AuthSessionEntity.Type type) {
        var query = FindByDeviceIdAndTypeInDayQuery.of(deviceId, type).getQuery();
        return mongoTemplate.count(query, AuthSessionDoc.class);
    }

    @Override
    public Long countSessionsByIpAndTypeInDay(String ip, AuthSessionEntity.Type type) {
        var query = FindByIpAndTypeInDayQuery.of(ip, type).getQuery();
        return mongoTemplate.count(query, AuthSessionDoc.class);
    }

    @Override
    public Long countByLoginDetailsAndTypeInHours(LoginDetails loginDetails, AuthSessionEntity.Type type) {
        var query = FindByLoginDetailsAndTypeInDayQuery.of(loginDetails, type).getQuery();
        return mongoTemplate.count(query, AuthSessionDoc.class);
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(AuthorizationSessionFilters filters) {
        return new FindWithFiltersQuery(filters);
    }


    @Override
    public List<AuthSessionEntity> findByClientInfoInDay(ClientInfo clientInfo) {
        var query = FindByClientInfoInDayQuery.of(clientInfo).getQuery();
        return mongoTemplate.find(query, AuthSessionDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }

    @Override
    public List<AuthSessionEntity> findByLoginDetailsInDay(LoginDetails loginDetails) {
        var query = FindByLoginDetailsInDayQuery.of(loginDetails).getQuery();
        return mongoTemplate.find(query, AuthSessionDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }

    @Override
    public void incrementAttempts(String authSessionId) {

    }
}
