package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.AccessTokenFilters;

import java.util.HashSet;
import java.util.Set;

public class FindAccessTokensQuery extends AbstractExampleQuery {

    private final AccessTokenFilters filters;

    public FindAccessTokensQuery(AccessTokenFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        Set<Criteria> criteriaSet = new HashSet<>(4);

        DeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaSet::add);

        if (filters.getCredentialId() != null)
            criteriaSet.add(Criteria.where("credential.$id").is(filters.getCredentialId()));

        if (filters.getCreateByRefreshTokenId() != null)
            criteriaSet.add(Criteria.where("createByRefreshToken.$id").is(new ObjectId(filters.getCreateByRefreshTokenId())));

        if (filters.getStatus() != null)
            criteriaSet.add(Criteria.where("status").is(filters.getStatus()));

        return criteriaSet.isEmpty() ? new Criteria() : new Criteria().andOperator(criteriaSet.toArray(Criteria[]::new));
    }
}
