package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query;

import com.rcore.database.mongo.commons.query.AbstractModifyQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Update;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;

@RequiredArgsConstructor(staticName = "of")
public class ExpireAccessTokenByRefreshTokenQuery extends AbstractModifyQuery {

    private final String refreshTokenId;

    @Override
    public Update getUpdate() {
        return Update.update("status", RefreshTokenEntity.Status.EXPIRED);
    }

    @Override
    public FindAndModifyOptions getModifyOptions() {
        return FindAndModifyOptions.options().returnNew(true);
    }

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                IsDeletedCriteria.getNotDeletedCriteria(),
                Criteria.where("createByRefreshTokenId").is(refreshTokenId)
        );
    }
}
