package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.domain.token.port.RefreshTokenRepository;
import ru.foodtechlab.lib.auth.service.domain.token.port.filter.RefreshTokenFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.mapper.RefreshTokenDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.model.RefreshTokenDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.DeactivateAllTokensByCredentialQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.ExpireRefreshTokenQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindAllActiveByUserIdQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.token.query.FindRefreshTokensQuery;

import java.util.List;
import java.util.stream.Collectors;

@Repository
public class MongoRefreshTokenRepository extends AbstractMongoSafeDeleteRepository<String, RefreshTokenEntity, RefreshTokenDoc, RefreshTokenFilters> implements RefreshTokenRepository {
    public MongoRefreshTokenRepository(RefreshTokenDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RefreshTokenDoc.class, mapper, mongoTemplate);
    }

    @Override
    public void expireRefreshToken(RefreshTokenEntity refreshTokenEntity) {
        ExpireRefreshTokenQuery expireRefreshTokenQuery = ExpireRefreshTokenQuery.of(refreshTokenEntity.getId());
        mongoTemplate.updateFirst(expireRefreshTokenQuery.getQuery(), expireRefreshTokenQuery.getUpdate(), RefreshTokenDoc.class);
    }

    @Override
    public List<RefreshTokenEntity> findAllActiveByUserId(String userId) {
        return mongoTemplate.find(FindAllActiveByUserIdQuery.of(userId).getQuery(), RefreshTokenDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }

    @Override
    public void deactivateByCredentialId(String credentialId) {
        DeactivateAllTokensByCredentialQuery query = DeactivateAllTokensByCredentialQuery.of(credentialId);

        mongoTemplate.update(documentClass)
                .matching(query.getQuery())
                .apply(query.getUpdate())
                .all();
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(RefreshTokenFilters filters) {
        return new FindRefreshTokensQuery(filters);
    }
}
