package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;

public class FindGodModeAccessQuery implements ExampleQuery {

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("serviceName").is("*"),
                Criteria.where("method").is(RoleAccessEntity.Method.ANY),
                Criteria.where("requestPathPattern").is("/**"),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
