package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;

import java.util.List;
import java.util.stream.Collectors;

@RequiredArgsConstructor(staticName = "of")
public class FindAccessesByRoleIdsQuery implements ExampleQuery {

    private final List<String> roleIds;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("role.$id").in(roleIds.stream().map(ObjectId::new).collect(Collectors.toList())),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
