package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.mapper;

import com.rcore.commons.mapper.ExampleDataMapper;
import lombok.RequiredArgsConstructor;
import org.bson.types.ObjectId;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.RoleAccessIdGenerator;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.roleAccess.model.RoleAccessDoc;

@RequiredArgsConstructor
@Component
public class RoleAccessDocMapper implements ExampleDataMapper<RoleAccessEntity, RoleAccessDoc> {

    private final RoleAccessIdGenerator<ObjectId> idGenerator;

    @Override
    public RoleAccessEntity inverseMap(RoleAccessDoc doc) {
        var access = new RoleAccessEntity();
        access.setId(doc.getId().toString());
        access.setUpdatedAt(doc.getUpdatedAt());
        access.setCreatedAt(doc.getCreatedAt());
        access.setDeleted(doc.isDeleted());
        access.setRequestPathPattern(doc.getRequestPathPattern());
        access.setMethod(doc.getMethod());
        access.setServiceName(doc.getServiceName());
        return access;
    }

    @Override
    public RoleAccessDoc map(RoleAccessEntity entity) {
        return RoleAccessDoc.builder()
                .id(idGenerator.parse(entity.getId()))
                .deleted(entity.isDeleted())
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .requestPathPattern(entity.getRequestPathPattern())
                .method(entity.getMethod())
                .serviceName(entity.getServiceName())
                .build();
    }

}
