package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.CollectionNameUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.domain.role.port.RoleRepository;
import ru.foodtechlab.lib.auth.service.domain.role.port.filters.RoleFilters;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.mapper.RoleDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model.RoleDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.DeleteAccessFromRolesQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.FindByCodeQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.query.FindRoleWithFiltersQuery;

import java.util.Optional;

@Repository
public class MongoRoleRepository extends AbstractMongoSafeDeleteRepository<String, RoleEntity, RoleDoc, RoleFilters> implements RoleRepository {

    public MongoRoleRepository(RoleDocMapper mapper, MongoTemplate mongoTemplate) {
        super(RoleDoc.class, mapper, mongoTemplate);
    }

    @Override
    public Optional<RoleEntity> findByCode(String code) {
        return Optional.ofNullable(mongoTemplate.findOne(FindByCodeQuery.of(code).getQuery(), RoleDoc.class))
                .map(mapper::inverseMap);
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(RoleFilters filters) {
        return new FindRoleWithFiltersQuery(filters);
    }

    @Override
    public void deleteRoleAccessFromRole(String accessId) {
        var query = DeleteAccessFromRolesQuery.of(accessId);
        mongoTemplate.update(documentClass)
                .matching(query.getQuery())
                .apply(query.getUpdate())
                .all();
    }

    public static String getCollectionName() {
        return CollectionNameUtils.getCollectionName(RoleDoc.class);
    }
}
