package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.role.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import io.foodtechlab.common.mongo.documents.BaseDeleteDocument;

import java.util.ArrayList;
import java.util.List;

@Document
@Getter
@Setter
@NoArgsConstructor
@SuperBuilder
public class RoleDoc extends BaseDeleteDocument {
    @Indexed
    private String name;
    @Indexed
    private String code;
    @Indexed
    private boolean isRegistrationAllowed;
    private List<String> accessIds = new ArrayList<>();

    @Field("isDeleted")
    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }
}
