package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import io.foodtechlab.common.mongo.util.IsDeletedCriteria;

@RequiredArgsConstructor(staticName = "of")
public class FindByEmailQuery implements ExampleQuery {

    private final String email;
    
    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("email.value").is(email.toLowerCase()),
                IsDeletedCriteria.getNotDeletedCriteria()
        );
    }
}
