package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.port;

import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;
import io.foodtechlab.common.domain.port.filters.DeleteFilter;
import io.foodtechlab.common.mongo.port.AbstractMongoSafeDeleteRepository;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.entity.ConfirmationCodeSendingTaskEntity;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.port.ConfirmationCodeSendingTaskRepository;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.mapper.ConfirmationCodeDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.mapper.ConfirmationCodeSendingTaskDocMapper;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.model.ConfirmationCodeSendingTaskDoc;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCodeSendingTask.query.FindPendingQuery;
import ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.credential.query.FindWithFiltersQuery;

import java.util.List;
import java.util.stream.Collectors;


@Repository
public class MongoConfirmationCodeSendingTaskRepository extends AbstractMongoSafeDeleteRepository<String, ConfirmationCodeSendingTaskEntity, ConfirmationCodeSendingTaskDoc, DeleteFilter>
        implements ConfirmationCodeSendingTaskRepository {

    public MongoConfirmationCodeSendingTaskRepository(ConfirmationCodeSendingTaskDocMapper mapper, MongoTemplate mongoTemplate) {
        super(ConfirmationCodeSendingTaskDoc.class, mapper, mongoTemplate);
    }

    @Override
    public List<ConfirmationCodeSendingTaskEntity> findPending(Long limit) {
        return mongoTemplate.find(new FindPendingQuery().getQuery().limit(limit.intValue()), ConfirmationCodeSendingTaskDoc.class)
                .stream()
                .map(mapper::inverseMap)
                .collect(Collectors.toList());
    }

    @Override
    protected AbstractExampleQuery getSearchQuery(DeleteFilter filters) {
        return new FindWithFiltersQuery(filters);
    }
}
