package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query;

import com.rcore.commons.utils.StringUtils;
import com.rcore.database.mongo.commons.query.AbstractExampleQuery;
import com.rcore.database.mongo.commons.utils.MongoQueryUtils;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.filter.ConfirmationCodeFilters;

import java.util.ArrayList;
import java.util.List;

public class FindWithFiltersQuery extends AbstractExampleQuery {

    private final ConfirmationCodeFilters filters;

    public FindWithFiltersQuery(ConfirmationCodeFilters filters) {
        super(filters);
        this.filters = filters;
    }

    @Override
    public Criteria getCriteria() {
        List<Criteria> criteriaList = new ArrayList<>();
        if (StringUtils.hasText(filters.getAuthSessionId()))
            criteriaList.add(Criteria.where("authSession.$id").is(new ObjectId(filters.getAuthSessionId())));
        if (StringUtils.hasText(filters.getDeviceId()))
            criteriaList.add(Criteria.where("deviceId").is(filters.getDeviceId()));
        if (StringUtils.hasText(filters.getQuery()))
            criteriaList.add(MongoQueryUtils.generateQueryRegEXCriteria(filters.getQuery(), "email", "phoneNumber"));
        if (filters.getConfirmationCodeDestinationType() != null)
            criteriaList.add(Criteria.where("confirmationCodeDestinationType").is(filters.getConfirmationCodeDestinationType()));
        if (filters.getConfirmationStatus() != null)
            criteriaList.add(Criteria.where("confirmationStatus").is(filters.getConfirmationStatus()));
        if (filters.getLoginType() != null)
            criteriaList.add(Criteria.where("loginType").is(filters.getLoginType()));
        DeletedCriteria.filterCriteria(filters.getDeleted())
                .ifPresent(criteriaList::add);

        return !criteriaList.isEmpty() ? new Criteria().andOperator(criteriaList.toArray(Criteria[]::new)) : new Criteria();
    }

}
