package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;

@RequiredArgsConstructor(staticName = "of")
public class FindLastNotConfirmedForCredentialQuery implements ExampleQuery {

    private final LoginDetails loginDetails;
    private final String deviceToken;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                loginDetails.getEmail() != null ? Criteria.where("email").is(loginDetails.getEmail()) : new Criteria(),
                loginDetails.getPhoneNumber() != null ? Criteria.where("phoneNumber").is(loginDetails.getPhoneNumber()) : new Criteria(),
                loginDetails.getUsername() != null ? Criteria.where("username").is(loginDetails.getUsername()) : new Criteria(),
                Criteria.where("deviceId").is(deviceToken),
                Criteria.where("confirmationStatus").is(ConfirmationCodeEntity.ConfirmationStatus.NOT_CONFIRMED),
                DeletedCriteria.getNotDeletedCriteria()
        );
    }
}
