package ru.foodtechlab.lib.auth.service.infrastructure.database.mongo.confirmationCode.query;

import com.rcore.database.mongo.commons.query.ExampleQuery;
import lombok.RequiredArgsConstructor;
import org.springframework.data.mongodb.core.query.Criteria;
import io.foodtechlab.common.mongo.util.DeletedCriteria;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;

@RequiredArgsConstructor(staticName = "of")
public class FindByLoginTypeQuery implements ExampleQuery {

    private final AuthSessionEntity.LoginType loginType;

    @Override
    public Criteria getCriteria() {
        return new Criteria().andOperator(
                Criteria.where("loginType").is(loginType),
                DeletedCriteria.getNotDeletedCriteria()
        );
    }
}
